#include <bits/stdc++.h>

using namespace std;

#ifdef SG
	#include "debug/debug.h"
#else
	#define debug(...)
#endif

#define forn(i,n) for (int i = 0; i < int(n); ++i)
#define ford(i,n) for (int i = int(n) - 1; i >= 0; --i)

#define fs first
#define sc second
#define mp make_pair
#define pb push_back
#define pa pair
#define ve vector

#define all(a) (a).begin(), (a).end()
#define sz(a) int((a).size())

typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;
typedef pair<int, int> pii;
typedef vector<int> vi;

template <typename T1, typename T2> bool umn (T1 & a, T2 b) {if (b < a) {a = b; return 1;} return 0;}
template <typename T1, typename T2> bool umx (T1 & a, T2 b) {if (a < b) {a = b; return 1;} return 0;}

struct Input {
	string s;
	
	bool read () {
		if (!getline(cin, s)) {
			return 0;
		}
		return s != "#";
	}
	
	void init (Input const & input) {
		*this = input;
	}
};


typedef pa<ld, ld> pt;
typedef pt Point;
#define x first
#define y second

pt operator + (const pt &a, const pt &b) {
	return pt(a.x + b.x, a.y + b.y);
}

pt operator - (const pt &a, const pt &b) {
	return pt(a.x - b.x, a.y - b.y);
}

pt operator * (const pt &a, ld b) {
	return pt(a.x * b, a.y * b);
}

ld operator * (const pt &a, const pt &b) {
	return a.x * b.x + a.y * b.y;
}

ld operator ^ (const pt &a, const pt &b) {
	return a.x * b.y - a.y * b.x;
}

struct Data: Input {
	Point ans;
	
	void write () {
		cout << ans.x << " " << ans.y << "\n";
	}
	
	virtual void solve () {}
	virtual void clear () {}
};

bool is_digit (char c) {
	return c >= '0' && c <= '9';
}

struct Solution: Data {
	Point reflect (Point const & p, Point const & a, Point const & b) {
		pt e = b - a;
		pt v = p - a;
		ld k = (v * e) / (e * e);
		pt c = a + e * k;
		return c * 2 - p;
	}
	
	Point intersect (Point const & a, Point const & b, Point const & c, Point const & d) {
		ld s1 = (c - a) ^ (c - b);
		ld s2 = (d - a) ^ (d - b);
		return (c * s2 - d * s1) * (1 / (s2 - s1));
	}
	
	vector<Point> process (vector<Point> a, vector<Point> b) {
		if (sz(a) > sz(b)) {
			swap(a, b);
		}
		if (sz(a) + sz(b) == 2) {
			return vector<Point>{a[0], b[0]};
		}
		else if (sz(a) + sz(b) == 4) {
			return vector<Point>{intersect(a[0], a[1], b[0], b[1])};
		}
		else {
			return vector<Point>{reflect(a[0], b[0], b[1])};
		}
	}
	
	int getNum (string const & s, int & i) {
		int sgn = 1;
		if (s[i] == '-') {
			sgn = -1;
			++i;
		}
		int x = 0;
		while (is_digit(s[i])) {
			x *= 10;
			x += s[i] - '0';
			++i;
		}
		return x * sgn;
	}
	
	vector<Point> getTerm (string const & s, int & i) {
		assert(s[i] == '(');
		if (s[i] == '(') {
			++i;
			vector<Point> res;
			if (is_digit(s[i]) || s[i] == '-') {
				int x = getNum(s, i);
				++i;
				int y = getNum(s, i);
				res = vector<Point>{Point(x, y)};
			}
			else {
				res = getExpr(s, i);
			}
			++i;
			return res;
		}
	}
	
	vector<Point> getExpr (string const & s, int & i) {
		vector<Point> res = getTerm(s, i);
		while (i < sz(s) && s[i] == '@') {
			++i;
			vector<Point> e(getTerm(s, i));
			res = process(res, e);
		}
		return res;
	}
	
	void solve () {
		int i = 0;
		ans = getExpr(s, i)[0];
	}
	
	void clear () {
		*this = Solution();
	}
};

Solution sol;

int main () {
	cout.precision(20);
	cout.setf(ios::fixed | ios::showpoint);
#ifdef SG
	freopen("h.in", "r", stdin);
//	freopen("", "w", stdout);
	while (sol.read()) {
		sol.solve();
		sol.write();
		sol.clear();
	}
#else
	while (sol.read()) {
		sol.solve();
		sol.write();
		sol.clear();
	}
#endif
	return 0;
}
